<?php

namespace Ankou;

use ManiaControl\ManiaControl;
use ManiaControl\Plugins\Plugin;
use ManiaControl\Players\Player;
use ManiaControl\Players\PlayerManager;
use ManiaControl\Callbacks\Callbacks;
use ManiaControl\Callbacks\CallbackListener;
use ManiaControl\Callbacks\CallbackManager;
use ManiaControl\Callbacks\TimerListener;
use ManiaControl\Callbacks\TimerManager;
use ManiaControl\Settings\Setting;
use ManiaControl\Settings\SettingManager;


/**
 * ManiaControl Promote2 Plugin
 *
 * @author G]R [SG-1] Sen-Sai
 * @author Ankou
 */
class Promote2Plugin implements CallbackListener, Plugin, TimerListener {
	/**
	 * Constants
	 */
	const PLUGIN_ID				= 55;
	const PLUGIN_VERSION		= 1.26;
	const PLUGIN_NAME			= 'Promote2Plugin';
	const PLUGIN_AUTHOR			= 'Ankou & Sen-sai';
	const DATE					= 'd-m-y h:i:sa T';

	const SETTING_PROMOTE_INTERVAL 		= 'Promote Interval';
	const SETTING_PROMOTE_MODE 			= 'Promote Mode'; // random or linear
	const SETTING_PROMOTE_TXT_0 		= 'Promote text A';
	const SETTING_PROMOTE_TXT_1 		= 'Promote text B';
	const SETTING_PROMOTE_TXT_2 		= 'Promote text C';
	const SETTING_PROMOTE_TXT_3 		= 'Promote text D';
	const SETTING_PROMOTE_TXT_4 		= 'Promote text E';
	const SETTING_PROMOTE_TXT_5 		= 'Promote text F';
	const SETTING_PROMOTE_TXT_6 		= 'Promote text G';
	const SETTING_PROMOTE_TXT_7 		= 'Promote text H';
	const SETTING_PROMOTE_TXT_8 		= 'Promote text I';
	const SETTING_PROMOTE_TXT_9 		= 'Promote text J';



	/**
	 * Private properties
	 */
	/** @var ManiaControl $maniaControl */
	private $maniaControl;
	private $message = array();
	private $msgIndex = 0;


		/**
	 * @see \ManiaControl\Plugins\Plugin::load()
	 */
	public function load(ManiaControl $maniaControl) {
		$this->maniaControl = $maniaControl;
		
		$this->loadIntoArray();
		
		//$this->nextMsg = time() + (int)$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_INTERVAL);
		
		$this->maniaControl->getCallbackManager()->registerCallbackListener(SettingManager::CB_SETTING_CHANGED, $this, 'handleSettingChangedCallback');
		$timer = (int)$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_INTERVAL) * 1000;
		$this->maniaControl->getTimerManager()->registerTimerListening($this, 'handleTimer', (int)$timer);
		
		return true;
	}

	/**
	 * Prepares the Plugin
	 *
	 * @param ManiaControl $maniaControl
	 * @return mixed
	 */
	public static function prepare(ManiaControl $maniaControl) {
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_INTERVAL, 120);
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_MODE, array('random','linear')); //random or linear
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_0, 'Type /list to add a map to the Jukebox.');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_1, 'Type /donate [planets] to donate to this server.');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_2, 'Rate this map by writing ++, or -- in the chat!');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_3, 'Like us on $l[https://www.facebook.com/glimratten]Facebook$l.');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_4, 'Use /helpall to see all available chat commands');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_5, '');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_6, '');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_7, '');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_8, '');
		$maniaControl->getSettingManager()->initSetting(get_class(), self::SETTING_PROMOTE_TXT_9, '');		
		
	}


	/**
	 * @see \ManiaControl\Plugins\Plugin::unload()
	 */
	public function unload() {
		
	}
	
	public function loadIntoArray()
	{
		$this->message = array();
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_0) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_0);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_1) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_1);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_2) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_2);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_3) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_3);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_4) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_4);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_5) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_5);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_6) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_6);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_7) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_7);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_8) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_8);
		}
		if ($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_9) != '')
		{
			$this->message[]=$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_TXT_9);
		}
	}


	public function handleSettingChangedCallback(Setting $setting) {
		if (!$setting->belongsToClass($this)) {
			return;
		}
		$this->loadIntoArray();
		//$this->nextMsg = time() + (int)$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_INTERVAL);
		$this->maniaControl->getChat()->sendInformation("Promotional settings save. Interval: ".(string)$this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_INTERVAL), null, false);
	}
	
	public function handleTimer() 
	{
		if($this->maniaControl->getPlayerManager()->getPlayerCount(false) === 0)	//Added by Ankou (useless to send messages without players)
			return;

		$preTxt = '$FF0» $0FFServer info: $fff';
		if (count($this->message) < 2)
		{
			$this->maniaControl->getChat()->sendInformation($preTxt.(string)$this->message[0], null, false);
		}
		else
		{
			if (strtolower($this->maniaControl->getSettingManager()->getSettingValue($this, self::SETTING_PROMOTE_MODE)) == 'linear') 
			{
				$this->maniaControl->getChat()->sendInformation($preTxt.(string)$this->message[$this->msgIndex], null, false);
				$this->msgIndex++;

				if ($this->msgIndex >= count($this->message))
				{
					$this->msgIndex = 0;
				}
				
			}
			else
			{
				$index = rand(0,count($this->message)-1);
				$this->maniaControl->getChat()->sendInformation($preTxt.(string)$this->message[$index], null, false);
			}
			
		}
	}

	
	/**
	 * @see \ManiaControl\Plugins\Plugin::getId()
	 */
	public static function getId() {
		return self::PLUGIN_ID;
	}

	/**
	 * @see \ManiaControl\Plugins\Plugin::getName()
	 */
	public static function getName() {
		return self::PLUGIN_NAME;
	}

	/**
	 * @see \ManiaControl\Plugins\Plugin::getVersion()
	 */
	public static function getVersion() {
		return self::PLUGIN_VERSION;
	}

	/**
	 * @see \ManiaControl\Plugins\Plugin::getAuthor()
	 */
	public static function getAuthor() {
		return self::PLUGIN_AUTHOR;
	}

	/**
	 * @see \ManiaControl\Plugins\Plugin::getDescription()
	 */
	public static function getDescription() {
		return 'Can show up to 10 promotional messages.';
	}


}
